//
//  table__s_b_i_x.h
//  GSFontTools
//
//  Created by Georg Seifert on 01.08.13.
//
//

#import <GSFontTools/TTable.h>

@class SBIXBitmapSet;
@class SBIXGlyph;

@interface table__s_b_i_x : TTable {
	uint16_t _version;
	uint16_t _flags;
	NSMutableDictionary *_bitmapSets;
}
@property (nonatomic) uint16_t version;
@property (nonatomic) uint16_t flags;
@property (nonatomic, retain) NSMutableDictionary *bitmapSets;

- (void)insertObject:(SBIXBitmapSet *)bitmapSet inBitmapSetsForKey:(id)key;

@end

@interface SBIXBitmapSet : NSObject {
	uint16_t _size;
	uint16_t _resolution;
	NSMutableDictionary *_bitmaps;
}
@property (nonatomic) uint16_t size;
@property (nonatomic) uint16_t resolution;
@property (nonatomic, retain) NSMutableDictionary *bitmaps;

- (void)insertObject:(SBIXGlyph *)bitmap inBitmapsForKey:(id)key;
- (BOOL)decompile:(NSData *)data pos:(NSUInteger)start font:(TTFont *)font error:(NSError **)error;
- (NSData *)compile:(TTFont *)font error:(NSError **)error;
- (void)toXML:(GSXMLWriter *)writer font:(TTFont *)font;

@end

@interface SBIXGlyph : NSObject

@property (nonatomic) uint16_t gid;
@property (nonatomic) uint16_t referenceGlyphID;
@property (nonatomic, retain) NSString *format;

@property (nonatomic) int16_t originOffsetX;
@property (nonatomic) int16_t originOffsetY;
@property (nonatomic, retain) NSData *imageData;

- (BOOL)decompile:(NSData *)data pos:(NSUInteger)pos length:(NSUInteger)length font:(TTFont *)font error:(NSError **)error;
- (BOOL)compile:(NSMutableData *)data font:(TTFont *)font error:(NSError **)error;
- (void)toXML:(GSXMLWriter *)writer font:(TTFont *)font;
@end
